package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionRequestStatus {
  def unwrap
      : software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus
}
object SubscriptionRequestStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus
  ): zio.aws.datazone.model.SubscriptionRequestStatus = value match {
    case software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.ACCEPTED =>
      val r = ACCEPTED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.REJECTED =>
      val r = REJECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.SubscriptionRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.datazone.model.SubscriptionRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.PENDING
  }
  case object ACCEPTED
      extends zio.aws.datazone.model.SubscriptionRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.ACCEPTED
  }
  case object REJECTED
      extends zio.aws.datazone.model.SubscriptionRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus.REJECTED
  }
}
