package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionGrantStatus {
  def unwrap
      : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus
}
object SubscriptionGrantStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus
  ): zio.aws.datazone.model.SubscriptionGrantStatus = value match {
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_PENDING =>
      val r = GRANT_PENDING
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_PENDING =>
      val r = REVOKE_PENDING
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_IN_PROGRESS =>
      val r = GRANT_IN_PROGRESS
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_IN_PROGRESS =>
      val r = REVOKE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANTED =>
      val r = GRANTED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKED =>
      val r = REVOKED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_FAILED =>
      val r = GRANT_FAILED
      r
    case software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_FAILED =>
      val r = REVOKE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object GRANT_PENDING
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_PENDING
  }
  case object REVOKE_PENDING
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_PENDING
  }
  case object GRANT_IN_PROGRESS
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_IN_PROGRESS
  }
  case object REVOKE_IN_PROGRESS
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_IN_PROGRESS
  }
  case object GRANTED extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANTED
  }
  case object REVOKED extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKED
  }
  case object GRANT_FAILED
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.GRANT_FAILED
  }
  case object REVOKE_FAILED
      extends zio.aws.datazone.model.SubscriptionGrantStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus =
      software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus.REVOKE_FAILED
  }
}
