package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.datazone.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.SortOrder
  ): zio.aws.datazone.model.SortOrder = value match {
    case software.amazon.awssdk.services.datazone.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.datazone.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortOrder =
      software.amazon.awssdk.services.datazone.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.datazone.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortOrder =
      software.amazon.awssdk.services.datazone.model.SortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.datazone.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.SortOrder =
      software.amazon.awssdk.services.datazone.model.SortOrder.DESCENDING
  }
}
