package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UserSearchText,
  PaginationToken,
  MaxResults,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchUserProfilesRequest(
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    searchText: Optional[UserSearchText] = Optional.Absent,
    userType: zio.aws.datazone.model.UserSearchType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest = {
    import SearchUserProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        searchText.map(value => UserSearchText.unwrap(value): java.lang.String)
      )(_.searchText)
      .userType(userType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchUserProfilesRequest.ReadOnly =
    zio.aws.datazone.model.SearchUserProfilesRequest.wrap(buildAwsValue())
}
object SearchUserProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchUserProfilesRequest =
      zio.aws.datazone.model.SearchUserProfilesRequest(
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchText.map(value => value),
        userType
      )
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def searchText: Optional[UserSearchText]
    def userType: zio.aws.datazone.model.UserSearchType
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchText: ZIO[Any, AwsError, UserSearchText] =
      AwsError.unwrapOptionField("searchText", searchText)
    def getUserType: ZIO[Any, Nothing, zio.aws.datazone.model.UserSearchType] =
      ZIO.succeed(userType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest
  ) extends zio.aws.datazone.model.SearchUserProfilesRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val searchText: Optional[UserSearchText] = zio.aws.core.internal
      .optionalFromNullable(impl.searchText())
      .map(value => zio.aws.datazone.model.primitives.UserSearchText(value))
    override val userType: zio.aws.datazone.model.UserSearchType =
      zio.aws.datazone.model.UserSearchType.wrap(impl.userType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest
  ): zio.aws.datazone.model.SearchUserProfilesRequest.ReadOnly = new Wrapper(
    impl
  )
}
