package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Attribute
import scala.jdk.CollectionConverters.*
final case class SearchSort(
    attribute: Attribute,
    order: Optional[zio.aws.datazone.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchSort = {
    import SearchSort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchSort
      .builder()
      .attribute(Attribute.unwrap(attribute): java.lang.String)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchSort.ReadOnly =
    zio.aws.datazone.model.SearchSort.wrap(buildAwsValue())
}
object SearchSort {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchSort
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchSort =
      zio.aws.datazone.model.SearchSort(attribute, order.map(value => value))
    def attribute: Attribute
    def order: Optional[zio.aws.datazone.model.SortOrder]
    def getAttribute: ZIO[Any, Nothing, Attribute] = ZIO.succeed(attribute)
    def getOrder: ZIO[Any, AwsError, zio.aws.datazone.model.SortOrder] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchSort
  ) extends zio.aws.datazone.model.SearchSort.ReadOnly {
    override val attribute: Attribute =
      zio.aws.datazone.model.primitives.Attribute(impl.attribute())
    override val order: Optional[zio.aws.datazone.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.datazone.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchSort
  ): zio.aws.datazone.model.SearchSort.ReadOnly = new Wrapper(impl)
}
