package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchInventoryResultItem(
    assetItem: Optional[zio.aws.datazone.model.AssetItem] = Optional.Absent,
    dataProductItem: Optional[zio.aws.datazone.model.DataProductSummary] =
      Optional.Absent,
    glossaryItem: Optional[zio.aws.datazone.model.GlossaryItem] =
      Optional.Absent,
    glossaryTermItem: Optional[zio.aws.datazone.model.GlossaryTermItem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem = {
    import SearchInventoryResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem
      .builder()
      .optionallyWith(assetItem.map(value => value.buildAwsValue()))(
        _.assetItem
      )
      .optionallyWith(dataProductItem.map(value => value.buildAwsValue()))(
        _.dataProductItem
      )
      .optionallyWith(glossaryItem.map(value => value.buildAwsValue()))(
        _.glossaryItem
      )
      .optionallyWith(glossaryTermItem.map(value => value.buildAwsValue()))(
        _.glossaryTermItem
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly =
    zio.aws.datazone.model.SearchInventoryResultItem.wrap(buildAwsValue())
}
object SearchInventoryResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SearchInventoryResultItem =
      zio.aws.datazone.model.SearchInventoryResultItem(
        assetItem.map(value => value.asEditable),
        dataProductItem.map(value => value.asEditable),
        glossaryItem.map(value => value.asEditable),
        glossaryTermItem.map(value => value.asEditable)
      )
    def assetItem: Optional[zio.aws.datazone.model.AssetItem.ReadOnly]
    def dataProductItem
        : Optional[zio.aws.datazone.model.DataProductSummary.ReadOnly]
    def glossaryItem: Optional[zio.aws.datazone.model.GlossaryItem.ReadOnly]
    def glossaryTermItem
        : Optional[zio.aws.datazone.model.GlossaryTermItem.ReadOnly]
    def getAssetItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.AssetItem.ReadOnly] =
      AwsError.unwrapOptionField("assetItem", assetItem)
    def getDataProductItem: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataProductSummary.ReadOnly
    ] = AwsError.unwrapOptionField("dataProductItem", dataProductItem)
    def getGlossaryItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryItem.ReadOnly] =
      AwsError.unwrapOptionField("glossaryItem", glossaryItem)
    def getGlossaryTermItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryTermItem.ReadOnly] =
      AwsError.unwrapOptionField("glossaryTermItem", glossaryTermItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem
  ) extends zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly {
    override val assetItem
        : Optional[zio.aws.datazone.model.AssetItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetItem())
        .map(value => zio.aws.datazone.model.AssetItem.wrap(value))
    override val dataProductItem
        : Optional[zio.aws.datazone.model.DataProductSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProductItem())
        .map(value => zio.aws.datazone.model.DataProductSummary.wrap(value))
    override val glossaryItem
        : Optional[zio.aws.datazone.model.GlossaryItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryItem())
        .map(value => zio.aws.datazone.model.GlossaryItem.wrap(value))
    override val glossaryTermItem
        : Optional[zio.aws.datazone.model.GlossaryTermItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTermItem())
        .map(value => zio.aws.datazone.model.GlossaryTermItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem
  ): zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly = new Wrapper(
    impl
  )
}
