package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UpdatedBy,
  CreatedAt,
  SubscriptionId,
  DomainId,
  CreatedBy,
  SubscriptionRequestId,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RevokeSubscriptionResponse(
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    domainId: DomainId,
    id: SubscriptionId,
    retainPermissions: Optional[Boolean] = Optional.Absent,
    status: zio.aws.datazone.model.SubscriptionStatus,
    subscribedListing: zio.aws.datazone.model.SubscribedListing,
    subscribedPrincipal: zio.aws.datazone.model.SubscribedPrincipal,
    subscriptionRequestId: Optional[SubscriptionRequestId] = Optional.Absent,
    updatedAt: UpdatedAt,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse = {
    import RevokeSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse
      .builder()
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(SubscriptionId.unwrap(id): java.lang.String)
      .optionallyWith(retainPermissions.map(value => value: java.lang.Boolean))(
        _.retainPermissions
      )
      .status(status.unwrap)
      .subscribedListing(subscribedListing.buildAwsValue())
      .subscribedPrincipal(subscribedPrincipal.buildAwsValue())
      .optionallyWith(
        subscriptionRequestId.map(value =>
          SubscriptionRequestId.unwrap(value): java.lang.String
        )
      )(_.subscriptionRequestId)
      .updatedAt(UpdatedAt.unwrap(updatedAt): Instant)
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly =
    zio.aws.datazone.model.RevokeSubscriptionResponse.wrap(buildAwsValue())
}
object RevokeSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RevokeSubscriptionResponse =
      zio.aws.datazone.model.RevokeSubscriptionResponse(
        createdAt,
        createdBy,
        domainId,
        id,
        retainPermissions.map(value => value),
        status,
        subscribedListing.asEditable,
        subscribedPrincipal.asEditable,
        subscriptionRequestId.map(value => value),
        updatedAt,
        updatedBy.map(value => value)
      )
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def domainId: DomainId
    def id: SubscriptionId
    def retainPermissions: Optional[Boolean]
    def status: zio.aws.datazone.model.SubscriptionStatus
    def subscribedListing: zio.aws.datazone.model.SubscribedListing.ReadOnly
    def subscribedPrincipal: zio.aws.datazone.model.SubscribedPrincipal.ReadOnly
    def subscriptionRequestId: Optional[SubscriptionRequestId]
    def updatedAt: UpdatedAt
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, SubscriptionId] = ZIO.succeed(id)
    def getRetainPermissions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retainPermissions", retainPermissions)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.SubscriptionStatus] =
      ZIO.succeed(status)
    def getSubscribedListing
        : ZIO[Any, Nothing, zio.aws.datazone.model.SubscribedListing.ReadOnly] =
      ZIO.succeed(subscribedListing)
    def getSubscribedPrincipal: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.SubscribedPrincipal.ReadOnly
    ] = ZIO.succeed(subscribedPrincipal)
    def getSubscriptionRequestId: ZIO[Any, AwsError, SubscriptionRequestId] =
      AwsError.unwrapOptionField("subscriptionRequestId", subscriptionRequestId)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAt] = ZIO.succeed(updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse
  ) extends zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly {
    override val createdAt: CreatedAt =
      zio.aws.datazone.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: SubscriptionId =
      zio.aws.datazone.model.primitives.SubscriptionId(impl.id())
    override val retainPermissions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.retainPermissions())
      .map(value => value: Boolean)
    override val status: zio.aws.datazone.model.SubscriptionStatus =
      zio.aws.datazone.model.SubscriptionStatus.wrap(impl.status())
    override val subscribedListing
        : zio.aws.datazone.model.SubscribedListing.ReadOnly =
      zio.aws.datazone.model.SubscribedListing.wrap(impl.subscribedListing())
    override val subscribedPrincipal
        : zio.aws.datazone.model.SubscribedPrincipal.ReadOnly =
      zio.aws.datazone.model.SubscribedPrincipal
        .wrap(impl.subscribedPrincipal())
    override val subscriptionRequestId: Optional[SubscriptionRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionRequestId())
        .map(value =>
          zio.aws.datazone.model.primitives.SubscriptionRequestId(value)
        )
    override val updatedAt: UpdatedAt =
      zio.aws.datazone.model.primitives.UpdatedAt(impl.updatedAt())
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RevokeSubscriptionResponse
  ): zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
