package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{SubscriptionId, DomainId}
import scala.jdk.CollectionConverters.*
final case class RevokeSubscriptionRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionId,
    retainPermissions: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest = {
    import RevokeSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionId.unwrap(identifier): java.lang.String)
      .optionallyWith(retainPermissions.map(value => value: java.lang.Boolean))(
        _.retainPermissions
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RevokeSubscriptionRequest.ReadOnly =
    zio.aws.datazone.model.RevokeSubscriptionRequest.wrap(buildAwsValue())
}
object RevokeSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RevokeSubscriptionRequest =
      zio.aws.datazone.model.RevokeSubscriptionRequest(
        domainIdentifier,
        identifier,
        retainPermissions.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: SubscriptionId
    def retainPermissions: Optional[Boolean]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionId] =
      ZIO.succeed(identifier)
    def getRetainPermissions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retainPermissions", retainPermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest
  ) extends zio.aws.datazone.model.RevokeSubscriptionRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionId =
      zio.aws.datazone.model.primitives.SubscriptionId(impl.identifier())
    override val retainPermissions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.retainPermissions())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RevokeSubscriptionRequest
  ): zio.aws.datazone.model.RevokeSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
