package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RejectRule(
    rule: Optional[zio.aws.datazone.model.RejectRuleBehavior] = Optional.Absent,
    threshold: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RejectRule = {
    import RejectRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RejectRule
      .builder()
      .optionallyWith(rule.map(value => value.unwrap))(_.rule)
      .optionallyWith(threshold.map(value => value: java.lang.Float))(
        _.threshold
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RejectRule.ReadOnly =
    zio.aws.datazone.model.RejectRule.wrap(buildAwsValue())
}
object RejectRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RejectRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RejectRule = zio.aws.datazone.model
      .RejectRule(rule.map(value => value), threshold.map(value => value))
    def rule: Optional[zio.aws.datazone.model.RejectRuleBehavior]
    def threshold: Optional[Float]
    def getRule: ZIO[Any, AwsError, zio.aws.datazone.model.RejectRuleBehavior] =
      AwsError.unwrapOptionField("rule", rule)
    def getThreshold: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("threshold", threshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RejectRule
  ) extends zio.aws.datazone.model.RejectRule.ReadOnly {
    override val rule: Optional[zio.aws.datazone.model.RejectRuleBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.datazone.model.RejectRuleBehavior.wrap(value))
    override val threshold: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RejectRule
  ): zio.aws.datazone.model.RejectRule.ReadOnly = new Wrapper(impl)
}
