package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class RejectChoice(
    predictionChoices: Optional[Iterable[Integer]] = Optional.Absent,
    predictionTarget: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RejectChoice = {
    import RejectChoice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RejectChoice
      .builder()
      .optionallyWith(
        predictionChoices.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.predictionChoices)
      .optionallyWith(predictionTarget.map(value => value: java.lang.String))(
        _.predictionTarget
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RejectChoice.ReadOnly =
    zio.aws.datazone.model.RejectChoice.wrap(buildAwsValue())
}
object RejectChoice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RejectChoice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RejectChoice =
      zio.aws.datazone.model.RejectChoice(
        predictionChoices.map(value => value),
        predictionTarget.map(value => value)
      )
    def predictionChoices: Optional[List[Integer]]
    def predictionTarget: Optional[String]
    def getPredictionChoices: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("predictionChoices", predictionChoices)
    def getPredictionTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("predictionTarget", predictionTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RejectChoice
  ) extends zio.aws.datazone.model.RejectChoice.ReadOnly {
    override val predictionChoices: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionChoices())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
    override val predictionTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.predictionTarget())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RejectChoice
  ): zio.aws.datazone.model.RejectChoice.ReadOnly = new Wrapper(impl)
}
