package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.RedshiftCredentialConfigurationSecretManagerArnString
import scala.jdk.CollectionConverters.*
final case class RedshiftCredentialConfiguration(
    secretManagerArn: RedshiftCredentialConfigurationSecretManagerArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration = {
    import RedshiftCredentialConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration
      .builder()
      .secretManagerArn(
        RedshiftCredentialConfigurationSecretManagerArnString.unwrap(
          secretManagerArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly =
    zio.aws.datazone.model.RedshiftCredentialConfiguration.wrap(buildAwsValue())
}
object RedshiftCredentialConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftCredentialConfiguration =
      zio.aws.datazone.model.RedshiftCredentialConfiguration(secretManagerArn)
    def secretManagerArn: RedshiftCredentialConfigurationSecretManagerArnString
    def getSecretManagerArn: ZIO[
      Any,
      Nothing,
      RedshiftCredentialConfigurationSecretManagerArnString
    ] = ZIO.succeed(secretManagerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration
  ) extends zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly {
    override val secretManagerArn
        : RedshiftCredentialConfigurationSecretManagerArnString =
      zio.aws.datazone.model.primitives
        .RedshiftCredentialConfigurationSecretManagerArnString(
          impl.secretManagerArn()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration
  ): zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly =
    new Wrapper(impl)
}
