package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecommendationConfiguration(
    enableBusinessNameGeneration: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RecommendationConfiguration = {
    import RecommendationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RecommendationConfiguration
      .builder()
      .optionallyWith(
        enableBusinessNameGeneration.map(value => value: java.lang.Boolean)
      )(_.enableBusinessNameGeneration)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RecommendationConfiguration.ReadOnly =
    zio.aws.datazone.model.RecommendationConfiguration.wrap(buildAwsValue())
}
object RecommendationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RecommendationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RecommendationConfiguration =
      zio.aws.datazone.model.RecommendationConfiguration(
        enableBusinessNameGeneration.map(value => value)
      )
    def enableBusinessNameGeneration: Optional[Boolean]
    def getEnableBusinessNameGeneration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableBusinessNameGeneration",
        enableBusinessNameGeneration
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RecommendationConfiguration
  ) extends zio.aws.datazone.model.RecommendationConfiguration.ReadOnly {
    override val enableBusinessNameGeneration: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBusinessNameGeneration())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RecommendationConfiguration
  ): zio.aws.datazone.model.RecommendationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
