package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  RoleArn,
  EnvironmentBlueprintId,
  RegionName,
  DomainId
}
import scala.jdk.CollectionConverters.*
final case class PutEnvironmentBlueprintConfigurationRequest(
    domainIdentifier: DomainId,
    enabledRegions: Iterable[RegionName],
    environmentBlueprintIdentifier: EnvironmentBlueprintId,
    manageAccessRoleArn: Optional[RoleArn] = Optional.Absent,
    provisioningRoleArn: Optional[RoleArn] = Optional.Absent,
    regionalParameters: Optional[Map[RegionName, Map[String, String]]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest = {
    import PutEnvironmentBlueprintConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .enabledRegions(enabledRegions.map { item =>
        RegionName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .environmentBlueprintIdentifier(
        EnvironmentBlueprintId.unwrap(
          environmentBlueprintIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        manageAccessRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.manageAccessRoleArn)
      .optionallyWith(
        provisioningRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.provisioningRoleArn)
      .optionallyWith(
        regionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (RegionName.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.regionalParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest.ReadOnly =
    zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest
      .wrap(buildAwsValue())
}
object PutEnvironmentBlueprintConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest =
      zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest(
        domainIdentifier,
        enabledRegions,
        environmentBlueprintIdentifier,
        manageAccessRoleArn.map(value => value),
        provisioningRoleArn.map(value => value),
        regionalParameters.map(value => value)
      )
    def domainIdentifier: DomainId
    def enabledRegions: List[RegionName]
    def environmentBlueprintIdentifier: EnvironmentBlueprintId
    def manageAccessRoleArn: Optional[RoleArn]
    def provisioningRoleArn: Optional[RoleArn]
    def regionalParameters: Optional[Map[RegionName, Map[String, String]]]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnabledRegions: ZIO[Any, Nothing, List[RegionName]] =
      ZIO.succeed(enabledRegions)
    def getEnvironmentBlueprintIdentifier
        : ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(environmentBlueprintIdentifier)
    def getManageAccessRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("manageAccessRoleArn", manageAccessRoleArn)
    def getProvisioningRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("provisioningRoleArn", provisioningRoleArn)
    def getRegionalParameters
        : ZIO[Any, AwsError, Map[RegionName, Map[String, String]]] =
      AwsError.unwrapOptionField("regionalParameters", regionalParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest
  ) extends zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val enabledRegions: List[RegionName] = impl
      .enabledRegions()
      .asScala
      .map { item =>
        zio.aws.datazone.model.primitives.RegionName(item)
      }
      .toList
    override val environmentBlueprintIdentifier: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.environmentBlueprintIdentifier())
    override val manageAccessRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.manageAccessRoleArn())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val provisioningRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningRoleArn())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val regionalParameters
        : Optional[Map[RegionName, Map[String, String]]] = zio.aws.core.internal
      .optionalFromNullable(impl.regionalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datazone.model.primitives.RegionName(key) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> (value: String)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest
  ): zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
