package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProjectMember(
    designation: zio.aws.datazone.model.UserDesignation,
    memberDetails: zio.aws.datazone.model.MemberDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ProjectMember = {
    import ProjectMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ProjectMember
      .builder()
      .designation(designation.unwrap)
      .memberDetails(memberDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ProjectMember.ReadOnly =
    zio.aws.datazone.model.ProjectMember.wrap(buildAwsValue())
}
object ProjectMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ProjectMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ProjectMember =
      zio.aws.datazone.model
        .ProjectMember(designation, memberDetails.asEditable)
    def designation: zio.aws.datazone.model.UserDesignation
    def memberDetails: zio.aws.datazone.model.MemberDetails.ReadOnly
    def getDesignation
        : ZIO[Any, Nothing, zio.aws.datazone.model.UserDesignation] =
      ZIO.succeed(designation)
    def getMemberDetails
        : ZIO[Any, Nothing, zio.aws.datazone.model.MemberDetails.ReadOnly] =
      ZIO.succeed(memberDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ProjectMember
  ) extends zio.aws.datazone.model.ProjectMember.ReadOnly {
    override val designation: zio.aws.datazone.model.UserDesignation =
      zio.aws.datazone.model.UserDesignation.wrap(impl.designation())
    override val memberDetails: zio.aws.datazone.model.MemberDetails.ReadOnly =
      zio.aws.datazone.model.MemberDetails.wrap(impl.memberDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ProjectMember
  ): zio.aws.datazone.model.ProjectMember.ReadOnly = new Wrapper(impl)
}
