package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait NotificationResourceType {
  def unwrap
      : software.amazon.awssdk.services.datazone.model.NotificationResourceType
}
object NotificationResourceType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.NotificationResourceType
  ): zio.aws.datazone.model.NotificationResourceType = value match {
    case software.amazon.awssdk.services.datazone.model.NotificationResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.NotificationResourceType.PROJECT =>
      val r = PROJECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.NotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationResourceType =
      software.amazon.awssdk.services.datazone.model.NotificationResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECT extends zio.aws.datazone.model.NotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationResourceType =
      software.amazon.awssdk.services.datazone.model.NotificationResourceType.PROJECT
  }
}
