package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationResource(
    id: String,
    name: Optional[String] = Optional.Absent,
    `type`: zio.aws.datazone.model.NotificationResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.NotificationResource = {
    import NotificationResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.NotificationResource
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.NotificationResource.ReadOnly =
    zio.aws.datazone.model.NotificationResource.wrap(buildAwsValue())
}
object NotificationResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.NotificationResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.NotificationResource =
      zio.aws.datazone.model
        .NotificationResource(id, name.map(value => value), `type`)
    def id: String
    def name: Optional[String]
    def `type`: zio.aws.datazone.model.NotificationResourceType
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType
        : ZIO[Any, Nothing, zio.aws.datazone.model.NotificationResourceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.NotificationResource
  ) extends zio.aws.datazone.model.NotificationResource.ReadOnly {
    override val id: String = impl.id(): String
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: zio.aws.datazone.model.NotificationResourceType =
      zio.aws.datazone.model.NotificationResourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.NotificationResource
  ): zio.aws.datazone.model.NotificationResource.ReadOnly = new Wrapper(impl)
}
