package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.Smithy
import scala.jdk.CollectionConverters.*
final case class Model(smithy: Optional[Smithy] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.datazone.model.Model = {
    import Model.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Model
      .builder()
      .optionallyWith(
        smithy.map(value => Smithy.unwrap(value): java.lang.String)
      )(_.smithy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Model.ReadOnly =
    zio.aws.datazone.model.Model.wrap(buildAwsValue())
}
object Model {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Model] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Model =
      zio.aws.datazone.model.Model(smithy.map(value => value))
    def smithy: Optional[Smithy]
    def getSmithy: ZIO[Any, AwsError, Smithy] =
      AwsError.unwrapOptionField("smithy", smithy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Model
  ) extends zio.aws.datazone.model.Model.ReadOnly {
    override val smithy: Optional[Smithy] = zio.aws.core.internal
      .optionalFromNullable(impl.smithy())
      .map(value => zio.aws.datazone.model.primitives.Smithy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Model
  ): zio.aws.datazone.model.Model.ReadOnly = new Wrapper(impl)
}
