package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MemberDetails(
    group: Optional[zio.aws.datazone.model.GroupDetails] = Optional.Absent,
    user: Optional[zio.aws.datazone.model.UserDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.MemberDetails = {
    import MemberDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.MemberDetails
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.MemberDetails.ReadOnly =
    zio.aws.datazone.model.MemberDetails.wrap(buildAwsValue())
}
object MemberDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.MemberDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.MemberDetails =
      zio.aws.datazone.model.MemberDetails(
        group.map(value => value.asEditable),
        user.map(value => value.asEditable)
      )
    def group: Optional[zio.aws.datazone.model.GroupDetails.ReadOnly]
    def user: Optional[zio.aws.datazone.model.UserDetails.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.datazone.model.GroupDetails.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
    def getUser
        : ZIO[Any, AwsError, zio.aws.datazone.model.UserDetails.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.MemberDetails
  ) extends zio.aws.datazone.model.MemberDetails.ReadOnly {
    override val group: Optional[zio.aws.datazone.model.GroupDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.datazone.model.GroupDetails.wrap(value))
    override val user: Optional[zio.aws.datazone.model.UserDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.datazone.model.UserDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.MemberDetails
  ): zio.aws.datazone.model.MemberDetails.ReadOnly = new Wrapper(impl)
}
