package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Member(
    groupIdentifier: Optional[String] = Optional.Absent,
    userIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.datazone.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Member
      .builder()
      .optionallyWith(groupIdentifier.map(value => value: java.lang.String))(
        _.groupIdentifier
      )
      .optionallyWith(userIdentifier.map(value => value: java.lang.String))(
        _.userIdentifier
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Member.ReadOnly =
    zio.aws.datazone.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Member] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Member =
      zio.aws.datazone.model.Member(
        groupIdentifier.map(value => value),
        userIdentifier.map(value => value)
      )
    def groupIdentifier: Optional[String]
    def userIdentifier: Optional[String]
    def getGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIdentifier", groupIdentifier)
    def getUserIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userIdentifier", userIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Member
  ) extends zio.aws.datazone.model.Member.ReadOnly {
    override val groupIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIdentifier())
      .map(value => value: String)
    override val userIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Member
  ): zio.aws.datazone.model.Member.ReadOnly = new Wrapper(impl)
}
