package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{Revision, ListingId}
import scala.jdk.CollectionConverters.*
final case class ListingRevisionInput(
    identifier: ListingId,
    revision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListingRevisionInput = {
    import ListingRevisionInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListingRevisionInput
      .builder()
      .identifier(ListingId.unwrap(identifier): java.lang.String)
      .revision(Revision.unwrap(revision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListingRevisionInput.ReadOnly =
    zio.aws.datazone.model.ListingRevisionInput.wrap(buildAwsValue())
}
object ListingRevisionInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListingRevisionInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListingRevisionInput =
      zio.aws.datazone.model.ListingRevisionInput(identifier, revision)
    def identifier: ListingId
    def revision: Revision
    def getIdentifier: ZIO[Any, Nothing, ListingId] = ZIO.succeed(identifier)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListingRevisionInput
  ) extends zio.aws.datazone.model.ListingRevisionInput.ReadOnly {
    override val identifier: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.identifier())
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListingRevisionInput
  ): zio.aws.datazone.model.ListingRevisionInput.ReadOnly = new Wrapper(impl)
}
