package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{Revision, ListingId}
import scala.jdk.CollectionConverters.*
final case class ListingRevision(id: ListingId, revision: Revision) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListingRevision = {
    import ListingRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListingRevision
      .builder()
      .id(ListingId.unwrap(id): java.lang.String)
      .revision(Revision.unwrap(revision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListingRevision.ReadOnly =
    zio.aws.datazone.model.ListingRevision.wrap(buildAwsValue())
}
object ListingRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListingRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListingRevision =
      zio.aws.datazone.model.ListingRevision(id, revision)
    def id: ListingId
    def revision: Revision
    def getId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(id)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListingRevision
  ) extends zio.aws.datazone.model.ListingRevision.ReadOnly {
    override val id: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.id())
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListingRevision
  ): zio.aws.datazone.model.ListingRevision.ReadOnly = new Wrapper(impl)
}
