package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  SubscriptionId,
  DomainId,
  PaginationToken,
  EnvironmentId,
  MaxResults,
  SubscriptionTargetId,
  ListingId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSubscriptionGrantsRequest(
    domainIdentifier: DomainId,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sortBy: Optional[zio.aws.datazone.model.SortKey] = Optional.Absent,
    sortOrder: Optional[zio.aws.datazone.model.SortOrder] = Optional.Absent,
    subscribedListingId: Optional[ListingId] = Optional.Absent,
    subscriptionId: Optional[SubscriptionId] = Optional.Absent,
    subscriptionTargetId: Optional[SubscriptionTargetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest = {
    import ListSubscriptionGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        subscribedListingId.map(value =>
          ListingId.unwrap(value): java.lang.String
        )
      )(_.subscribedListingId)
      .optionallyWith(
        subscriptionId.map(value =>
          SubscriptionId.unwrap(value): java.lang.String
        )
      )(_.subscriptionId)
      .optionallyWith(
        subscriptionTargetId.map(value =>
          SubscriptionTargetId.unwrap(value): java.lang.String
        )
      )(_.subscriptionTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListSubscriptionGrantsRequest.ReadOnly =
    zio.aws.datazone.model.ListSubscriptionGrantsRequest.wrap(buildAwsValue())
}
object ListSubscriptionGrantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListSubscriptionGrantsRequest =
      zio.aws.datazone.model.ListSubscriptionGrantsRequest(
        domainIdentifier,
        environmentId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        subscribedListingId.map(value => value),
        subscriptionId.map(value => value),
        subscriptionTargetId.map(value => value)
      )
    def domainIdentifier: DomainId
    def environmentId: Optional[EnvironmentId]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def sortBy: Optional[zio.aws.datazone.model.SortKey]
    def sortOrder: Optional[zio.aws.datazone.model.SortOrder]
    def subscribedListingId: Optional[ListingId]
    def subscriptionId: Optional[SubscriptionId]
    def subscriptionTargetId: Optional[SubscriptionTargetId]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.datazone.model.SortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.datazone.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSubscribedListingId: ZIO[Any, AwsError, ListingId] =
      AwsError.unwrapOptionField("subscribedListingId", subscribedListingId)
    def getSubscriptionId: ZIO[Any, AwsError, SubscriptionId] =
      AwsError.unwrapOptionField("subscriptionId", subscriptionId)
    def getSubscriptionTargetId: ZIO[Any, AwsError, SubscriptionTargetId] =
      AwsError.unwrapOptionField("subscriptionTargetId", subscriptionTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest
  ) extends zio.aws.datazone.model.ListSubscriptionGrantsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.datazone.model.primitives.EnvironmentId(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val sortBy: Optional[zio.aws.datazone.model.SortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.datazone.model.SortKey.wrap(value))
    override val sortOrder: Optional[zio.aws.datazone.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.datazone.model.SortOrder.wrap(value))
    override val subscribedListingId: Optional[ListingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscribedListingId())
        .map(value => zio.aws.datazone.model.primitives.ListingId(value))
    override val subscriptionId: Optional[SubscriptionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionId())
        .map(value => zio.aws.datazone.model.primitives.SubscriptionId(value))
    override val subscriptionTargetId: Optional[SubscriptionTargetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionTargetId())
        .map(value =>
          zio.aws.datazone.model.primitives.SubscriptionTargetId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest
  ): zio.aws.datazone.model.ListSubscriptionGrantsRequest.ReadOnly =
    new Wrapper(impl)
}
