package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  EnvironmentBlueprintName,
  MaxResults,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentBlueprintsRequest(
    domainIdentifier: DomainId,
    managed: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    name: Optional[EnvironmentBlueprintName] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest = {
    import ListEnvironmentBlueprintsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(managed.map(value => value: java.lang.Boolean))(_.managed)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        name.map(value =>
          EnvironmentBlueprintName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListEnvironmentBlueprintsRequest.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentBlueprintsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentBlueprintsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListEnvironmentBlueprintsRequest =
      zio.aws.datazone.model.ListEnvironmentBlueprintsRequest(
        domainIdentifier,
        managed.map(value => value),
        maxResults.map(value => value),
        name.map(value => value),
        nextToken.map(value => value)
      )
    def domainIdentifier: DomainId
    def managed: Optional[Boolean]
    def maxResults: Optional[MaxResults]
    def name: Optional[EnvironmentBlueprintName]
    def nextToken: Optional[PaginationToken]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managed", managed)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, EnvironmentBlueprintName] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest
  ) extends zio.aws.datazone.model.ListEnvironmentBlueprintsRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val managed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.managed())
      .map(value => value: Boolean)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val name: Optional[EnvironmentBlueprintName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.datazone.model.primitives.EnvironmentBlueprintName(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest
  ): zio.aws.datazone.model.ListEnvironmentBlueprintsRequest.ReadOnly =
    new Wrapper(impl)
}
