package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  MaxResultsForListDomains
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDomainsRequest(
    maxResults: Optional[MaxResultsForListDomains] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.DomainStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListDomainsRequest = {
    import ListDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListDomainsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResultsForListDomains.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListDomainsRequest.ReadOnly =
    zio.aws.datazone.model.ListDomainsRequest.wrap(buildAwsValue())
}
object ListDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListDomainsRequest =
      zio.aws.datazone.model.ListDomainsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def maxResults: Optional[MaxResultsForListDomains]
    def nextToken: Optional[PaginationToken]
    def status: Optional[zio.aws.datazone.model.DomainStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResultsForListDomains] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListDomainsRequest
  ) extends zio.aws.datazone.model.ListDomainsRequest.ReadOnly {
    override val maxResults: Optional[MaxResultsForListDomains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.datazone.model.primitives.MaxResultsForListDomains(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val status: Optional[zio.aws.datazone.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.DomainStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListDomainsRequest
  ): zio.aws.datazone.model.ListDomainsRequest.ReadOnly = new Wrapper(impl)
}
