package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  DomainId,
  PaginationToken,
  MaxResults,
  DataSourceType,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDataSourcesRequest(
    domainIdentifier: DomainId,
    environmentIdentifier: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    projectIdentifier: String,
    status: Optional[zio.aws.datazone.model.DataSourceStatus] = Optional.Absent,
    `type`: Optional[DataSourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest = {
    import ListDataSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        environmentIdentifier.map(value => value: java.lang.String)
      )(_.environmentIdentifier)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .projectIdentifier(projectIdentifier: java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        `type`.map(value => DataSourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListDataSourcesRequest.ReadOnly =
    zio.aws.datazone.model.ListDataSourcesRequest.wrap(buildAwsValue())
}
object ListDataSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListDataSourcesRequest =
      zio.aws.datazone.model.ListDataSourcesRequest(
        domainIdentifier,
        environmentIdentifier.map(value => value),
        maxResults.map(value => value),
        name.map(value => value),
        nextToken.map(value => value),
        projectIdentifier,
        status.map(value => value),
        `type`.map(value => value)
      )
    def domainIdentifier: DomainId
    def environmentIdentifier: Optional[String]
    def maxResults: Optional[MaxResults]
    def name: Optional[Name]
    def nextToken: Optional[PaginationToken]
    def projectIdentifier: String
    def status: Optional[zio.aws.datazone.model.DataSourceStatus]
    def `type`: Optional[DataSourceType]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentIdentifier", environmentIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(projectIdentifier)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest
  ) extends zio.aws.datazone.model.ListDataSourcesRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentIdentifier())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.Name(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val projectIdentifier: String = impl.projectIdentifier(): String
    override val status: Optional[zio.aws.datazone.model.DataSourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.DataSourceStatus.wrap(value))
    override val `type`: Optional[DataSourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.datazone.model.primitives.DataSourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourcesRequest
  ): zio.aws.datazone.model.ListDataSourcesRequest.ReadOnly = new Wrapper(impl)
}
