package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListDataSourceRunsResponse(
    items: Iterable[zio.aws.datazone.model.DataSourceRunSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse = {
    import ListDataSourceRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly =
    zio.aws.datazone.model.ListDataSourceRunsResponse.wrap(buildAwsValue())
}
object ListDataSourceRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListDataSourceRunsResponse =
      zio.aws.datazone.model.ListDataSourceRunsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.datazone.model.DataSourceRunSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse
  ) extends zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly {
    override val items
        : List[zio.aws.datazone.model.DataSourceRunSummary.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.datazone.model.DataSourceRunSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse
  ): zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly = new Wrapper(
    impl
  )
}
