package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  PaginationToken,
  MaxResults,
  DataSourceRunId,
  DomainId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDataSourceRunActivitiesRequest(
    domainIdentifier: DomainId,
    identifier: DataSourceRunId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.DataAssetActivityStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest = {
    import ListDataSourceRunActivitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(DataSourceRunId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListDataSourceRunActivitiesRequest.ReadOnly =
    zio.aws.datazone.model.ListDataSourceRunActivitiesRequest
      .wrap(buildAwsValue())
}
object ListDataSourceRunActivitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListDataSourceRunActivitiesRequest =
      zio.aws.datazone.model.ListDataSourceRunActivitiesRequest(
        domainIdentifier,
        identifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: DataSourceRunId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def status: Optional[zio.aws.datazone.model.DataAssetActivityStatus]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, DataSourceRunId] =
      ZIO.succeed(identifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.DataAssetActivityStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest
  ) extends zio.aws.datazone.model.ListDataSourceRunActivitiesRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: DataSourceRunId =
      zio.aws.datazone.model.primitives.DataSourceRunId(impl.identifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val status
        : Optional[zio.aws.datazone.model.DataAssetActivityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.datazone.model.DataAssetActivityStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest
  ): zio.aws.datazone.model.ListDataSourceRunActivitiesRequest.ReadOnly =
    new Wrapper(impl)
}
