package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GroupDetails(groupId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GroupDetails = {
    import GroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GroupDetails
      .builder()
      .groupId(groupId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GroupDetails.ReadOnly =
    zio.aws.datazone.model.GroupDetails.wrap(buildAwsValue())
}
object GroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GroupDetails =
      zio.aws.datazone.model.GroupDetails(groupId)
    def groupId: String
    def getGroupId: ZIO[Any, Nothing, String] = ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GroupDetails
  ) extends zio.aws.datazone.model.GroupDetails.ReadOnly {
    override val groupId: String = impl.groupId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GroupDetails
  ): zio.aws.datazone.model.GroupDetails.ReadOnly = new Wrapper(impl)
}
