package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  GlueRunConfigurationOutputRegionString,
  GlueRunConfigurationOutputDataAccessRoleString,
  GlueRunConfigurationOutputAccountIdString
}
import scala.jdk.CollectionConverters.*
final case class GlueRunConfigurationOutput(
    accountId: Optional[GlueRunConfigurationOutputAccountIdString] =
      Optional.Absent,
    dataAccessRole: Optional[GlueRunConfigurationOutputDataAccessRoleString] =
      Optional.Absent,
    region: Optional[GlueRunConfigurationOutputRegionString] = Optional.Absent,
    relationalFilterConfigurations: Iterable[
      zio.aws.datazone.model.RelationalFilterConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput = {
    import GlueRunConfigurationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput
      .builder()
      .optionallyWith(
        accountId.map(value =>
          GlueRunConfigurationOutputAccountIdString.unwrap(
            value
          ): java.lang.String
        )
      )(_.accountId)
      .optionallyWith(
        dataAccessRole.map(value =>
          GlueRunConfigurationOutputDataAccessRoleString.unwrap(
            value
          ): java.lang.String
        )
      )(_.dataAccessRole)
      .optionallyWith(
        region.map(value =>
          GlueRunConfigurationOutputRegionString.unwrap(value): java.lang.String
        )
      )(_.region)
      .relationalFilterConfigurations(relationalFilterConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly =
    zio.aws.datazone.model.GlueRunConfigurationOutput.wrap(buildAwsValue())
}
object GlueRunConfigurationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GlueRunConfigurationOutput =
      zio.aws.datazone.model.GlueRunConfigurationOutput(
        accountId.map(value => value),
        dataAccessRole.map(value => value),
        region.map(value => value),
        relationalFilterConfigurations.map { item =>
          item.asEditable
        }
      )
    def accountId: Optional[GlueRunConfigurationOutputAccountIdString]
    def dataAccessRole: Optional[GlueRunConfigurationOutputDataAccessRoleString]
    def region: Optional[GlueRunConfigurationOutputRegionString]
    def relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly]
    def getAccountId
        : ZIO[Any, AwsError, GlueRunConfigurationOutputAccountIdString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDataAccessRole
        : ZIO[Any, AwsError, GlueRunConfigurationOutputDataAccessRoleString] =
      AwsError.unwrapOptionField("dataAccessRole", dataAccessRole)
    def getRegion: ZIO[Any, AwsError, GlueRunConfigurationOutputRegionString] =
      AwsError.unwrapOptionField("region", region)
    def getRelationalFilterConfigurations: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly
    ]] = ZIO.succeed(relationalFilterConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput
  ) extends zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly {
    override val accountId
        : Optional[GlueRunConfigurationOutputAccountIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountId())
        .map(value =>
          zio.aws.datazone.model.primitives
            .GlueRunConfigurationOutputAccountIdString(value)
        )
    override val dataAccessRole
        : Optional[GlueRunConfigurationOutputDataAccessRoleString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRole())
        .map(value =>
          zio.aws.datazone.model.primitives
            .GlueRunConfigurationOutputDataAccessRoleString(value)
        )
    override val region: Optional[GlueRunConfigurationOutputRegionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          zio.aws.datazone.model.primitives
            .GlueRunConfigurationOutputRegionString(value)
        )
    override val relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly] =
      impl
        .relationalFilterConfigurations()
        .asScala
        .map { item =>
          zio.aws.datazone.model.RelationalFilterConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GlueRunConfigurationOutput
  ): zio.aws.datazone.model.GlueRunConfigurationOutput.ReadOnly = new Wrapper(
    impl
  )
}
