package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.GlueRunConfigurationInputDataAccessRoleString
import scala.jdk.CollectionConverters.*
final case class GlueRunConfigurationInput(
    dataAccessRole: Optional[GlueRunConfigurationInputDataAccessRoleString] =
      Optional.Absent,
    relationalFilterConfigurations: Iterable[
      zio.aws.datazone.model.RelationalFilterConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput = {
    import GlueRunConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput
      .builder()
      .optionallyWith(
        dataAccessRole.map(value =>
          GlueRunConfigurationInputDataAccessRoleString.unwrap(
            value
          ): java.lang.String
        )
      )(_.dataAccessRole)
      .relationalFilterConfigurations(relationalFilterConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly =
    zio.aws.datazone.model.GlueRunConfigurationInput.wrap(buildAwsValue())
}
object GlueRunConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GlueRunConfigurationInput =
      zio.aws.datazone.model.GlueRunConfigurationInput(
        dataAccessRole.map(value => value),
        relationalFilterConfigurations.map { item =>
          item.asEditable
        }
      )
    def dataAccessRole: Optional[GlueRunConfigurationInputDataAccessRoleString]
    def relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly]
    def getDataAccessRole
        : ZIO[Any, AwsError, GlueRunConfigurationInputDataAccessRoleString] =
      AwsError.unwrapOptionField("dataAccessRole", dataAccessRole)
    def getRelationalFilterConfigurations: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly
    ]] = ZIO.succeed(relationalFilterConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput
  ) extends zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly {
    override val dataAccessRole
        : Optional[GlueRunConfigurationInputDataAccessRoleString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRole())
        .map(value =>
          zio.aws.datazone.model.primitives
            .GlueRunConfigurationInputDataAccessRoleString(value)
        )
    override val relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly] =
      impl
        .relationalFilterConfigurations()
        .asScala
        .map { item =>
          zio.aws.datazone.model.RelationalFilterConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput
  ): zio.aws.datazone.model.GlueRunConfigurationInput.ReadOnly = new Wrapper(
    impl
  )
}
