package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{UserIdentifier, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetUserProfileRequest(
    domainIdentifier: DomainId,
    `type`: Optional[zio.aws.datazone.model.UserProfileType] = Optional.Absent,
    userIdentifier: UserIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetUserProfileRequest = {
    import GetUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetUserProfileRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .userIdentifier(UserIdentifier.unwrap(userIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetUserProfileRequest.ReadOnly =
    zio.aws.datazone.model.GetUserProfileRequest.wrap(buildAwsValue())
}
object GetUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetUserProfileRequest =
      zio.aws.datazone.model.GetUserProfileRequest(
        domainIdentifier,
        `type`.map(value => value),
        userIdentifier
      )
    def domainIdentifier: DomainId
    def `type`: Optional[zio.aws.datazone.model.UserProfileType]
    def userIdentifier: UserIdentifier
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getType: ZIO[Any, AwsError, zio.aws.datazone.model.UserProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUserIdentifier: ZIO[Any, Nothing, UserIdentifier] =
      ZIO.succeed(userIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetUserProfileRequest
  ) extends zio.aws.datazone.model.GetUserProfileRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val `type`: Optional[zio.aws.datazone.model.UserProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.datazone.model.UserProfileType.wrap(value))
    override val userIdentifier: UserIdentifier =
      zio.aws.datazone.model.primitives.UserIdentifier(impl.userIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetUserProfileRequest
  ): zio.aws.datazone.model.GetUserProfileRequest.ReadOnly = new Wrapper(impl)
}
