package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  SubscriptionGrantId,
  UpdatedBy,
  CreatedAt,
  SubscriptionId,
  DomainId,
  CreatedBy,
  SubscriptionTargetId,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetSubscriptionGrantResponse(
    assets: Optional[Iterable[zio.aws.datazone.model.SubscribedAsset]] =
      Optional.Absent,
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    domainId: DomainId,
    grantedEntity: zio.aws.datazone.model.GrantedEntity,
    id: SubscriptionGrantId,
    status: zio.aws.datazone.model.SubscriptionGrantOverallStatus,
    subscriptionId: Optional[SubscriptionId] = Optional.Absent,
    subscriptionTargetId: SubscriptionTargetId,
    updatedAt: UpdatedAt,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse = {
    import GetSubscriptionGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .grantedEntity(grantedEntity.buildAwsValue())
      .id(SubscriptionGrantId.unwrap(id): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        subscriptionId.map(value =>
          SubscriptionId.unwrap(value): java.lang.String
        )
      )(_.subscriptionId)
      .subscriptionTargetId(
        SubscriptionTargetId.unwrap(subscriptionTargetId): java.lang.String
      )
      .updatedAt(UpdatedAt.unwrap(updatedAt): Instant)
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly =
    zio.aws.datazone.model.GetSubscriptionGrantResponse.wrap(buildAwsValue())
}
object GetSubscriptionGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetSubscriptionGrantResponse =
      zio.aws.datazone.model.GetSubscriptionGrantResponse(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt,
        createdBy,
        domainId,
        grantedEntity.asEditable,
        id,
        status,
        subscriptionId.map(value => value),
        subscriptionTargetId,
        updatedAt,
        updatedBy.map(value => value)
      )
    def assets: Optional[List[zio.aws.datazone.model.SubscribedAsset.ReadOnly]]
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def domainId: DomainId
    def grantedEntity: zio.aws.datazone.model.GrantedEntity.ReadOnly
    def id: SubscriptionGrantId
    def status: zio.aws.datazone.model.SubscriptionGrantOverallStatus
    def subscriptionId: Optional[SubscriptionId]
    def subscriptionTargetId: SubscriptionTargetId
    def updatedAt: UpdatedAt
    def updatedBy: Optional[UpdatedBy]
    def getAssets: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.SubscribedAsset.ReadOnly
    ]] = AwsError.unwrapOptionField("assets", assets)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getGrantedEntity
        : ZIO[Any, Nothing, zio.aws.datazone.model.GrantedEntity.ReadOnly] =
      ZIO.succeed(grantedEntity)
    def getId: ZIO[Any, Nothing, SubscriptionGrantId] = ZIO.succeed(id)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.SubscriptionGrantOverallStatus
    ] = ZIO.succeed(status)
    def getSubscriptionId: ZIO[Any, AwsError, SubscriptionId] =
      AwsError.unwrapOptionField("subscriptionId", subscriptionId)
    def getSubscriptionTargetId: ZIO[Any, Nothing, SubscriptionTargetId] =
      ZIO.succeed(subscriptionTargetId)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAt] = ZIO.succeed(updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse
  ) extends zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly {
    override val assets
        : Optional[List[zio.aws.datazone.model.SubscribedAsset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.SubscribedAsset.wrap(item)
          }.toList
        )
    override val createdAt: CreatedAt =
      zio.aws.datazone.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val grantedEntity: zio.aws.datazone.model.GrantedEntity.ReadOnly =
      zio.aws.datazone.model.GrantedEntity.wrap(impl.grantedEntity())
    override val id: SubscriptionGrantId =
      zio.aws.datazone.model.primitives.SubscriptionGrantId(impl.id())
    override val status: zio.aws.datazone.model.SubscriptionGrantOverallStatus =
      zio.aws.datazone.model.SubscriptionGrantOverallStatus.wrap(impl.status())
    override val subscriptionId: Optional[SubscriptionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionId())
        .map(value => zio.aws.datazone.model.primitives.SubscriptionId(value))
    override val subscriptionTargetId: SubscriptionTargetId =
      zio.aws.datazone.model.primitives
        .SubscriptionTargetId(impl.subscriptionTargetId())
    override val updatedAt: UpdatedAt =
      zio.aws.datazone.model.primitives.UpdatedAt(impl.updatedAt())
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantResponse
  ): zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly = new Wrapper(
    impl
  )
}
