package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{SubscriptionGrantId, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetSubscriptionGrantRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionGrantId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest = {
    import GetSubscriptionGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionGrantId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetSubscriptionGrantRequest.ReadOnly =
    zio.aws.datazone.model.GetSubscriptionGrantRequest.wrap(buildAwsValue())
}
object GetSubscriptionGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetSubscriptionGrantRequest =
      zio.aws.datazone.model
        .GetSubscriptionGrantRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: SubscriptionGrantId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionGrantId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest
  ) extends zio.aws.datazone.model.GetSubscriptionGrantRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionGrantId =
      zio.aws.datazone.model.primitives.SubscriptionGrantId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionGrantRequest
  ): zio.aws.datazone.model.GetSubscriptionGrantRequest.ReadOnly = new Wrapper(
    impl
  )
}
