package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetIamPortalLoginUrlResponse(
    authCodeUrl: Optional[String] = Optional.Absent,
    userProfileId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse = {
    import GetIamPortalLoginUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse
      .builder()
      .optionallyWith(authCodeUrl.map(value => value: java.lang.String))(
        _.authCodeUrl
      )
      .userProfileId(userProfileId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly =
    zio.aws.datazone.model.GetIamPortalLoginUrlResponse.wrap(buildAwsValue())
}
object GetIamPortalLoginUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetIamPortalLoginUrlResponse =
      zio.aws.datazone.model.GetIamPortalLoginUrlResponse(
        authCodeUrl.map(value => value),
        userProfileId
      )
    def authCodeUrl: Optional[String]
    def userProfileId: String
    def getAuthCodeUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authCodeUrl", authCodeUrl)
    def getUserProfileId: ZIO[Any, Nothing, String] = ZIO.succeed(userProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse
  ) extends zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly {
    override val authCodeUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authCodeUrl())
      .map(value => value: String)
    override val userProfileId: String = impl.userProfileId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetIamPortalLoginUrlResponse
  ): zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
