package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{GlossaryId, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetGlossaryRequest(
    domainIdentifier: DomainId,
    identifier: GlossaryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetGlossaryRequest = {
    import GetGlossaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetGlossaryRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(GlossaryId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetGlossaryRequest.ReadOnly =
    zio.aws.datazone.model.GetGlossaryRequest.wrap(buildAwsValue())
}
object GetGlossaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetGlossaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetGlossaryRequest =
      zio.aws.datazone.model.GetGlossaryRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: GlossaryId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryRequest
  ) extends zio.aws.datazone.model.GetGlossaryRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetGlossaryRequest
  ): zio.aws.datazone.model.GetGlossaryRequest.ReadOnly = new Wrapper(impl)
}
