package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{EnvironmentProfileId, DomainId}
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentProfileRequest(
    domainIdentifier: DomainId,
    identifier: EnvironmentProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest = {
    import GetEnvironmentProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(EnvironmentProfileId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetEnvironmentProfileRequest.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentProfileRequest.wrap(buildAwsValue())
}
object GetEnvironmentProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentProfileRequest =
      zio.aws.datazone.model
        .GetEnvironmentProfileRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: EnvironmentProfileId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentProfileId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest
  ) extends zio.aws.datazone.model.GetEnvironmentProfileRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: EnvironmentProfileId =
      zio.aws.datazone.model.primitives.EnvironmentProfileId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileRequest
  ): zio.aws.datazone.model.GetEnvironmentProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
