package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  AssetTypeIdentifier,
  DomainId
}
import scala.jdk.CollectionConverters.*
final case class GetAssetTypeRequest(
    domainIdentifier: DomainId,
    identifier: AssetTypeIdentifier,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest = {
    import GetAssetTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetTypeIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetAssetTypeRequest.ReadOnly =
    zio.aws.datazone.model.GetAssetTypeRequest.wrap(buildAwsValue())
}
object GetAssetTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetAssetTypeRequest =
      zio.aws.datazone.model.GetAssetTypeRequest(
        domainIdentifier,
        identifier,
        revision.map(value => value)
      )
    def domainIdentifier: DomainId
    def identifier: AssetTypeIdentifier
    def revision: Optional[Revision]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetTypeIdentifier] =
      ZIO.succeed(identifier)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest
  ) extends zio.aws.datazone.model.GetAssetTypeRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetTypeIdentifier =
      zio.aws.datazone.model.primitives.AssetTypeIdentifier(impl.identifier())
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetAssetTypeRequest
  ): zio.aws.datazone.model.GetAssetTypeRequest.ReadOnly = new Wrapper(impl)
}
