package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Revision, FormTypeName, FormName}
import scala.jdk.CollectionConverters.*
final case class FormOutput(
    content: Optional[String] = Optional.Absent,
    formName: FormName,
    typeName: Optional[FormTypeName] = Optional.Absent,
    typeRevision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FormOutput = {
    import FormOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FormOutput
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .formName(FormName.unwrap(formName): java.lang.String)
      .optionallyWith(
        typeName.map(value => FormTypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.typeRevision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FormOutput.ReadOnly =
    zio.aws.datazone.model.FormOutput.wrap(buildAwsValue())
}
object FormOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FormOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FormOutput =
      zio.aws.datazone.model.FormOutput(
        content.map(value => value),
        formName,
        typeName.map(value => value),
        typeRevision.map(value => value)
      )
    def content: Optional[String]
    def formName: FormName
    def typeName: Optional[FormTypeName]
    def typeRevision: Optional[Revision]
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getFormName: ZIO[Any, Nothing, FormName] = ZIO.succeed(formName)
    def getTypeName: ZIO[Any, AwsError, FormTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("typeRevision", typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FormOutput
  ) extends zio.aws.datazone.model.FormOutput.ReadOnly {
    override val content: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => value: String)
    override val formName: FormName =
      zio.aws.datazone.model.primitives.FormName(impl.formName())
    override val typeName: Optional[FormTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.datazone.model.primitives.FormTypeName(value))
    override val typeRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.typeRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FormOutput
  ): zio.aws.datazone.model.FormOutput.ReadOnly = new Wrapper(impl)
}
