package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{Revision, FormTypeName}
import scala.jdk.CollectionConverters.*
final case class FormEntryOutput(
    required: Optional[Boolean] = Optional.Absent,
    typeName: FormTypeName,
    typeRevision: Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FormEntryOutput = {
    import FormEntryOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FormEntryOutput
      .builder()
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .typeName(FormTypeName.unwrap(typeName): java.lang.String)
      .typeRevision(Revision.unwrap(typeRevision): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FormEntryOutput.ReadOnly =
    zio.aws.datazone.model.FormEntryOutput.wrap(buildAwsValue())
}
object FormEntryOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FormEntryOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FormEntryOutput =
      zio.aws.datazone.model
        .FormEntryOutput(required.map(value => value), typeName, typeRevision)
    def required: Optional[Boolean]
    def typeName: FormTypeName
    def typeRevision: Revision
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getTypeName: ZIO[Any, Nothing, FormTypeName] = ZIO.succeed(typeName)
    def getTypeRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FormEntryOutput
  ) extends zio.aws.datazone.model.FormEntryOutput.ReadOnly {
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
    override val typeName: FormTypeName =
      zio.aws.datazone.model.primitives.FormTypeName(impl.typeName())
    override val typeRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.typeRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FormEntryOutput
  ): zio.aws.datazone.model.FormEntryOutput.ReadOnly = new Wrapper(impl)
}
