package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait FilterExpressionType {
  def unwrap
      : software.amazon.awssdk.services.datazone.model.FilterExpressionType
}
object FilterExpressionType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.FilterExpressionType
  ): zio.aws.datazone.model.FilterExpressionType = value match {
    case software.amazon.awssdk.services.datazone.model.FilterExpressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.FilterExpressionType.INCLUDE =>
      val r = INCLUDE
      r
    case software.amazon.awssdk.services.datazone.model.FilterExpressionType.EXCLUDE =>
      val r = EXCLUDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.FilterExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.FilterExpressionType =
      software.amazon.awssdk.services.datazone.model.FilterExpressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INCLUDE extends zio.aws.datazone.model.FilterExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.FilterExpressionType =
      software.amazon.awssdk.services.datazone.model.FilterExpressionType.INCLUDE
  }
  case object EXCLUDE extends zio.aws.datazone.model.FilterExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.FilterExpressionType =
      software.amazon.awssdk.services.datazone.model.FilterExpressionType.EXCLUDE
  }
}
