package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{FilterValueString, Attribute}
import scala.jdk.CollectionConverters.*
final case class Filter(attribute: Attribute, value: FilterValueString) {
  def buildAwsValue(): software.amazon.awssdk.services.datazone.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Filter
      .builder()
      .attribute(Attribute.unwrap(attribute): java.lang.String)
      .value(FilterValueString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Filter.ReadOnly =
    zio.aws.datazone.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Filter =
      zio.aws.datazone.model.Filter(attribute, value)
    def attribute: Attribute
    def value: FilterValueString
    def getAttribute: ZIO[Any, Nothing, Attribute] = ZIO.succeed(attribute)
    def getValue: ZIO[Any, Nothing, FilterValueString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Filter
  ) extends zio.aws.datazone.model.Filter.ReadOnly {
    override val attribute: Attribute =
      zio.aws.datazone.model.primitives.Attribute(impl.attribute())
    override val value: FilterValueString =
      zio.aws.datazone.model.primitives.FilterValueString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Filter
  ): zio.aws.datazone.model.Filter.ReadOnly = new Wrapper(impl)
}
