package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailureCause(message: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FailureCause = {
    import FailureCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FailureCause
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FailureCause.ReadOnly =
    zio.aws.datazone.model.FailureCause.wrap(buildAwsValue())
}
object FailureCause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FailureCause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FailureCause =
      zio.aws.datazone.model.FailureCause(message.map(value => value))
    def message: Optional[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FailureCause
  ) extends zio.aws.datazone.model.FailureCause.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FailureCause
  ): zio.aws.datazone.model.FailureCause.ReadOnly = new Wrapper(impl)
}
