package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileId,
  ProjectId,
  SyntheticTimestamp_date_time,
  EnvironmentName,
  DomainId,
  EnvironmentId,
  Description,
  AwsRegion,
  AwsAccountId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EnvironmentSummary(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBy: String,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    environmentProfileId: EnvironmentProfileId,
    id: Optional[EnvironmentId] = Optional.Absent,
    name: EnvironmentName,
    projectId: ProjectId,
    provider: String,
    status: Optional[zio.aws.datazone.model.EnvironmentStatus] =
      Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.EnvironmentSummary = {
    import EnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.EnvironmentSummary
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .createdBy(createdBy: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .environmentProfileId(
        EnvironmentProfileId.unwrap(environmentProfileId): java.lang.String
      )
      .optionallyWith(
        id.map(value => EnvironmentId.unwrap(value): java.lang.String)
      )(_.id)
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .provider(provider: java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.EnvironmentSummary.ReadOnly =
    zio.aws.datazone.model.EnvironmentSummary.wrap(buildAwsValue())
}
object EnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.EnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.EnvironmentSummary =
      zio.aws.datazone.model.EnvironmentSummary(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        createdAt.map(value => value),
        createdBy,
        description.map(value => value),
        domainId,
        environmentProfileId,
        id.map(value => value),
        name,
        projectId,
        provider,
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def createdBy: String
    def description: Optional[Description]
    def domainId: DomainId
    def environmentProfileId: EnvironmentProfileId
    def id: Optional[EnvironmentId]
    def name: EnvironmentName
    def projectId: ProjectId
    def provider: String
    def status: Optional[zio.aws.datazone.model.EnvironmentStatus]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, Nothing, String] = ZIO.succeed(createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnvironmentProfileId: ZIO[Any, Nothing, EnvironmentProfileId] =
      ZIO.succeed(environmentProfileId)
    def getId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getProvider: ZIO[Any, Nothing, String] = ZIO.succeed(provider)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentSummary
  ) extends zio.aws.datazone.model.EnvironmentSummary.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBy: String = impl.createdBy(): String
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val environmentProfileId: EnvironmentProfileId =
      zio.aws.datazone.model.primitives
        .EnvironmentProfileId(impl.environmentProfileId())
    override val id: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.EnvironmentId(value))
    override val name: EnvironmentName =
      zio.aws.datazone.model.primitives.EnvironmentName(impl.name())
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val provider: String = impl.provider(): String
    override val status: Optional[zio.aws.datazone.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.EnvironmentStatus.wrap(value))
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentSummary
  ): zio.aws.datazone.model.EnvironmentSummary.ReadOnly = new Wrapper(impl)
}
