package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.datazone.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.EntityType
  ): zio.aws.datazone.model.EntityType = value match {
    case software.amazon.awssdk.services.datazone.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.EntityType.ASSET =>
      val r = ASSET
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.EntityType =
      software.amazon.awssdk.services.datazone.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSET extends zio.aws.datazone.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.EntityType =
      software.amazon.awssdk.services.datazone.model.EntityType.ASSET
  }
}
