package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  CreatedAt,
  DomainName,
  DomainId,
  UpdatedAt,
  DomainDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DomainSummary(
    arn: String,
    createdAt: CreatedAt,
    description: Optional[DomainDescription] = Optional.Absent,
    id: DomainId,
    lastUpdatedAt: Optional[UpdatedAt] = Optional.Absent,
    managedAccountId: String,
    name: DomainName,
    portalUrl: Optional[String] = Optional.Absent,
    status: zio.aws.datazone.model.DomainStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DomainSummary = {
    import DomainSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DomainSummary
      .builder()
      .arn(arn: java.lang.String)
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value =>
          DomainDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .id(DomainId.unwrap(id): java.lang.String)
      .optionallyWith(
        lastUpdatedAt.map(value => UpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .managedAccountId(managedAccountId: java.lang.String)
      .name(DomainName.unwrap(name): java.lang.String)
      .optionallyWith(portalUrl.map(value => value: java.lang.String))(
        _.portalUrl
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DomainSummary.ReadOnly =
    zio.aws.datazone.model.DomainSummary.wrap(buildAwsValue())
}
object DomainSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DomainSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DomainSummary =
      zio.aws.datazone.model.DomainSummary(
        arn,
        createdAt,
        description.map(value => value),
        id,
        lastUpdatedAt.map(value => value),
        managedAccountId,
        name,
        portalUrl.map(value => value),
        status
      )
    def arn: String
    def createdAt: CreatedAt
    def description: Optional[DomainDescription]
    def id: DomainId
    def lastUpdatedAt: Optional[UpdatedAt]
    def managedAccountId: String
    def name: DomainName
    def portalUrl: Optional[String]
    def status: zio.aws.datazone.model.DomainStatus
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, DomainDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(id)
    def getLastUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getManagedAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(managedAccountId)
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
    def getPortalUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("portalUrl", portalUrl)
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.DomainStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DomainSummary
  ) extends zio.aws.datazone.model.DomainSummary.ReadOnly {
    override val arn: String = impl.arn(): String
    override val createdAt: CreatedAt =
      zio.aws.datazone.model.primitives.CreatedAt(impl.createdAt())
    override val description: Optional[DomainDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.DomainDescription(value)
        )
    override val id: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.id())
    override val lastUpdatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val managedAccountId: String = impl.managedAccountId(): String
    override val name: DomainName =
      zio.aws.datazone.model.primitives.DomainName(impl.name())
    override val portalUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.portalUrl())
      .map(value => value: String)
    override val status: zio.aws.datazone.model.DomainStatus =
      zio.aws.datazone.model.DomainStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DomainSummary
  ): zio.aws.datazone.model.DomainSummary.ReadOnly = new Wrapper(impl)
}
