package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.DeploymentMessage
import scala.jdk.CollectionConverters.*
final case class Deployment(
    deploymentId: Optional[String] = Optional.Absent,
    deploymentStatus: Optional[zio.aws.datazone.model.DeploymentStatus] =
      Optional.Absent,
    deploymentType: Optional[zio.aws.datazone.model.DeploymentType] =
      Optional.Absent,
    failureReason: Optional[zio.aws.datazone.model.EnvironmentError] =
      Optional.Absent,
    isDeploymentComplete: Optional[Boolean] = Optional.Absent,
    messages: Optional[Iterable[DeploymentMessage]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Deployment
      .builder()
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(failureReason.map(value => value.buildAwsValue()))(
        _.failureReason
      )
      .optionallyWith(
        isDeploymentComplete.map(value => value: java.lang.Boolean)
      )(_.isDeploymentComplete)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            DeploymentMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Deployment.ReadOnly =
    zio.aws.datazone.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.Deployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Deployment =
      zio.aws.datazone.model.Deployment(
        deploymentId.map(value => value),
        deploymentStatus.map(value => value),
        deploymentType.map(value => value),
        failureReason.map(value => value.asEditable),
        isDeploymentComplete.map(value => value),
        messages.map(value => value)
      )
    def deploymentId: Optional[String]
    def deploymentStatus: Optional[zio.aws.datazone.model.DeploymentStatus]
    def deploymentType: Optional[zio.aws.datazone.model.DeploymentType]
    def failureReason
        : Optional[zio.aws.datazone.model.EnvironmentError.ReadOnly]
    def isDeploymentComplete: Optional[Boolean]
    def messages: Optional[List[DeploymentMessage]]
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.DeploymentStatus] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.datazone.model.DeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getFailureReason
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnvironmentError.ReadOnly] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getIsDeploymentComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDeploymentComplete", isDeploymentComplete)
    def getMessages: ZIO[Any, AwsError, List[DeploymentMessage]] =
      AwsError.unwrapOptionField("messages", messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Deployment
  ) extends zio.aws.datazone.model.Deployment.ReadOnly {
    override val deploymentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => value: String)
    override val deploymentStatus
        : Optional[zio.aws.datazone.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatus())
        .map(value => zio.aws.datazone.model.DeploymentStatus.wrap(value))
    override val deploymentType
        : Optional[zio.aws.datazone.model.DeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.datazone.model.DeploymentType.wrap(value))
    override val failureReason
        : Optional[zio.aws.datazone.model.EnvironmentError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.datazone.model.EnvironmentError.wrap(value))
    override val isDeploymentComplete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDeploymentComplete())
      .map(value => value: Boolean)
    override val messages: Optional[List[DeploymentMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.DeploymentMessage(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Deployment
  ): zio.aws.datazone.model.Deployment.ReadOnly = new Wrapper(impl)
}
