package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{ProjectId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteProjectRequest(
    domainIdentifier: DomainId,
    identifier: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteProjectRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(ProjectId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteProjectRequest.ReadOnly =
    zio.aws.datazone.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteProjectRequest =
      zio.aws.datazone.model.DeleteProjectRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: ProjectId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteProjectRequest
  ) extends zio.aws.datazone.model.DeleteProjectRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteProjectRequest
  ): zio.aws.datazone.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
