package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{EnvironmentBlueprintId, DomainId}
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentBlueprintConfigurationRequest(
    domainIdentifier: DomainId,
    environmentBlueprintIdentifier: EnvironmentBlueprintId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest = {
    import DeleteEnvironmentBlueprintConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentBlueprintIdentifier(
        EnvironmentBlueprintId.unwrap(
          environmentBlueprintIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.ReadOnly =
    zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteEnvironmentBlueprintConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest =
      zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest(
        domainIdentifier,
        environmentBlueprintIdentifier
      )
    def domainIdentifier: DomainId
    def environmentBlueprintIdentifier: EnvironmentBlueprintId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentBlueprintIdentifier
        : ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(environmentBlueprintIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
  ) extends zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentBlueprintIdentifier: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.environmentBlueprintIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
  ): zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
