package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDomainResponse(
    status: zio.aws.datazone.model.DomainStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteDomainResponse = {
    import DeleteDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteDomainResponse
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteDomainResponse.ReadOnly =
    zio.aws.datazone.model.DeleteDomainResponse.wrap(buildAwsValue())
}
object DeleteDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteDomainResponse =
      zio.aws.datazone.model.DeleteDomainResponse(status)
    def status: zio.aws.datazone.model.DomainStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.datazone.model.DomainStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDomainResponse
  ) extends zio.aws.datazone.model.DeleteDomainResponse.ReadOnly {
    override val status: zio.aws.datazone.model.DomainStatus =
      zio.aws.datazone.model.DomainStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDomainResponse
  ): zio.aws.datazone.model.DeleteDomainResponse.ReadOnly = new Wrapper(impl)
}
