package zio.aws.datazone.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceRunType {
  def unwrap: software.amazon.awssdk.services.datazone.model.DataSourceRunType
}
object DataSourceRunType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DataSourceRunType
  ): zio.aws.datazone.model.DataSourceRunType = value match {
    case software.amazon.awssdk.services.datazone.model.DataSourceRunType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunType.PRIORITIZED =>
      val r = PRIORITIZED
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceRunType.SCHEDULED =>
      val r = SCHEDULED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DataSourceRunType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunType =
      software.amazon.awssdk.services.datazone.model.DataSourceRunType.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIORITIZED extends zio.aws.datazone.model.DataSourceRunType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunType =
      software.amazon.awssdk.services.datazone.model.DataSourceRunType.PRIORITIZED
  }
  case object SCHEDULED extends zio.aws.datazone.model.DataSourceRunType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceRunType =
      software.amazon.awssdk.services.datazone.model.DataSourceRunType.SCHEDULED
  }
}
